/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Inventories;

public class EdCatwalkBlock
extends StandardBlocks.HorizontalFourWayWaterLoggable {
    final Block railing_block;
    final AABB base_aabb;

    public EdCatwalkBlock(long config, BlockBehaviour.Properties properties, AABB base_aabb, AABB railing_aabb, Block railing_block) {
        super(config, properties, base_aabb, railing_aabb, 0);
        this.railing_block = railing_block;
        this.base_aabb = base_aabb;
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
    }

    public static boolean place_consume(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, int shrink) {
        if (!world.m_7731_(pos, state, 3)) {
            return false;
        }
        world.m_5594_(player, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_7500_() && !world.m_5776_()) {
            ItemStack stack = player.m_21120_(hand);
            if (shrink >= 0) {
                stack.m_41774_(shrink);
            } else if (stack.m_41613_() < stack.m_41741_()) {
                stack.m_41769_(Math.abs(shrink));
            } else {
                Inventories.give(player, new ItemStack((ItemLike)stack.m_41720_(), Math.abs(shrink)));
            }
            Inventories.setItemInPlayerHand(player, hand, stack);
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = player.m_21120_(hand).m_41720_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        Block block = ((BlockItem)item).m_40614_();
        if (block == this) {
            if (hit.m_82434_().m_122434_().m_122479_()) {
                return InteractionResult.PASS;
            }
            BlockPos adjacent_pos = pos.m_142300_(player.m_6350_());
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            if (adjacent_state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, adjacent_pos, hit.m_82434_().m_122424_(), player.m_21120_(hand), hit.m_82434_()))) {
                BlockState place_state = this.m_49966_();
                place_state = (BlockState)place_state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.m_60819_().m_76152_() == Fluids.f_76193_));
                EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (block == this.railing_block) {
            BooleanProperty railing;
            Direction face = hit.m_82434_();
            Vec3 rhv = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)hit.m_82425_()));
            if (face.m_122434_().m_122479_()) {
                if (rhv.m_82559_(Vec3.m_82528_((Vec3i)face.m_122436_())).m_82490_(2.0).m_82556_() < 0.99) {
                    face = face.m_122424_();
                }
            } else if (player.m_20238_(Vec3.m_82512_((Vec3i)pos)) < 3.0) {
                face = Direction.m_122366_((double)rhv.f_82479_, (double)0.0, (double)rhv.f_82481_);
            } else {
                face = Direction.m_122366_((double)player.m_20154_().f_82479_, (double)0.0, (double)player.m_20154_().f_82481_);
                List<Direction> free_sides = Arrays.stream(Direction.values()).filter(d -> d.m_122434_().m_122479_() && world.m_8055_(pos.m_142300_(d)).m_60734_() != this).toList();
                if (free_sides.isEmpty()) {
                    return InteractionResult.m_19078_((boolean)world.m_5776_());
                }
                if (!free_sides.contains(face)) {
                    face = free_sides.get(0);
                }
            }
            boolean add = (Boolean)state.m_61143_((Property)(railing = EdCatwalkBlock.getDirectionProperty(face))) == false;
            EdCatwalkBlock.place_consume((BlockState)state.m_61124_((Property)railing, (Comparable)Boolean.valueOf(add)), world, pos, player, hand, add ? 1 : -1);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
        if (world.m_5776_()) {
            return Collections.singletonList(ItemStack.f_41583_);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        int n = ((Boolean)state.m_61143_((Property)NORTH) != false ? 1 : 0) + ((Boolean)state.m_61143_((Property)EAST) != false ? 1 : 0) + ((Boolean)state.m_61143_((Property)SOUTH) != false ? 1 : 0) + ((Boolean)state.m_61143_((Property)WEST) != false ? 1 : 0);
        if (n > 0) {
            drops.add(new ItemStack((ItemLike)this.railing_block, n));
        }
        return drops;
    }
}

